'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Created by jack on 2017/6/19.
 */
(function (w, $) {
    /**
     * 删除弹窗
     * @param fn 点击按钮执行函数
     * @param obj   弹窗内容配置
     * @constructor
     */
    var CONFIRM = function () {
        function CONFIRM(fn, obj) {
            _classCallCheck(this, CONFIRM);

            var mask = $('.mask');
            this.callback = fn;
            this.config = obj;
            this.mask = mask;
            this.btn1 = $('.alert-btn .btn', mask).eq(0);
            this.btn2 = $('.alert-btn .btn', mask).eq(1);
            this.show();
        }

        _createClass(CONFIRM, [{
            key: 'show',
            value: function show() {
                var that = this,
                    obj = this.config,
                    mask = this.mask,
                    btn1 = this.btn1,
                    btn2 = this.btn2;
                $('.alert-title', mask).text(obj.title);
                $('.alert-content', mask).html(obj.content);
                if (obj.btn.length == 2) {
                    btn1.text(obj.btn[0]).on('click', function () {
                        that.sure(false);
                    });
                    btn2.text(obj.btn[1]).on('click', function () {
                        that.sure(true);
                    });
                } else {
                    btn1.hide();
                    btn2.text(obj.btn[0]).on('click', function () {
                        that.sure(true);
                    });
                }

                // mask.css('display', 'flex');
                $('.mask>div').hide();
                mask.css('display', 'flex').addClass('fadeIn');
                if (qs_c_obj.platformInfo.browser == 'IE') {
                    mask.css({
                        display: 'block',
                        paddingTop: '200px'
                    });
                }
                $('.qs_alert', mask).show().addClass('fadeIn-down');
            }
        }, {
            key: 'sure',
            value: function sure(type) {
                var mask = $('.mask'),
                    fn = this.callback;

                if ((typeof fn === 'undefined' ? 'undefined' : _typeof(fn)).toLowerCase() == 'function') fn(type);
                mask.removeClass('fadeIn').addClass('fadeOut');
                $('.qs_alert', mask).removeClass('fadeIn-down').addClass('fadeOut-down');
                $('.alert-btn .btn', mask).off('click');

                setTimeout(function () {
                    mask.css('display', 'none').removeClass('fadeOut');
                    $('.qs_alert', mask).hide().removeClass('fadeOut-down');
                }, 199);
            }
        }]);

        return CONFIRM;
    }();

    /**
     * 顶部提示确认框
     */


    var TIPS = function () {
        function TIPS(cfg, fn) {
            _classCallCheck(this, TIPS);

            this.cfg = cfg;
            var dom = $('#link'),
                btn = $('.btn', dom);
            btn.removeClass('disable').show();
            this.dom = dom;
            this.btn1 = btn.eq(0);
            this.btn2 = btn.eq(1);
            this.content = $('.tip-content', dom);
            this.render();
            this.event();
            typeof fn == 'function' && fn();
            this.show();
        }

        _createClass(TIPS, [{
            key: 'render',
            value: function render() {

                var btn = this.cfg.btn,
                    btn1 = this.btn1,
                    btn2 = this.btn2,
                    content = this.cfg.content;
                if (btn.length > 1) {
                    btn1.text(btn[0].value);
                    btn[0].type && btn[0].type && btn1.addClass('disable');
                    btn2.text(btn[1].value);
                    btn[1].type && btn[1].type && btn2.addClass('disable');
                } else {
                    btn2.text(btn[0].value);
                    btn[0].type && btn[0].type && btn1.addClass('disable');
                    btn1.hide();
                }
                this.content.html(content);
            }
        }, {
            key: 'event',
            value: function event() {
                var that = this,
                    btn1 = this.btn1,
                    btn2 = this.btn2;
                btn1.off().on('click', function () {
                    that.handle(false);
                });
                btn2.off().on('click', function () {
                    that.handle(true);
                });
            }
        }, {
            key: 'show',
            value: function show() {
                var dom = this.dom;
                dom.show().addClass('fadeIn-up');
            }
        }, {
            key: 'handle',
            value: function handle(type) {
                var dom = this.dom;
                var callback = this.cfg.callback;
                typeof callback == 'function' && callback.call(this, type);
                dom.removeClass('fadeIn-up').addClass('fadeOut-up');
                setTimeout(function () {
                    dom.hide().removeClass('fadeOut-up');
                }, 200);
            }
        }]);

        return TIPS;
    }();

    /**
     * 正在处理提示框
     */


    var PROCESS = function () {
        function PROCESS(dom) {
            _classCallCheck(this, PROCESS);

            var html = '<div class="top-tip"></div>';
            this.dom = $(html);
            this.wrap = dom;
            this.timer = null;
            $(dom).append(this.dom);
        }

        _createClass(PROCESS, [{
            key: 'alert',
            value: function alert(message) {
                var dom = this.dom;
                dom.html('').append($('<p class="tip-content load">' + message + '</p>'));
                dom.show().addClass('fadeIn-down');
            }
        }, {
            key: 'done',
            value: function done(message) {
                var that = this,
                    dom = this.dom;
                dom.html('').append($('<p class="tip-content done">' + message + '</p>'));
                if (!this.timer) {
                    clearTimeout(this.timer);
                    that.timer = setTimeout(function () {
                        dom.removeClass('fadeIn-down').addClass('fadeOut-down');
                        setTimeout(function () {
                            dom.hide().removeClass('fadeOut-down');
                            that.timer = null;
                        }, 200);
                    }, 1000);
                }
            }
        }, {
            key: 'warn',
            value: function warn(message) {
                var that = this,
                    dom = this.dom;
                dom.html('').append($('<p class="tip-content warn">' + message + '</p>')).show().addClass('fadeIn-down');
                if (!this.timer) {
                    clearTimeout(this.timer);
                    that.timer = setTimeout(function () {
                        dom.hide().removeClass('fadeIn-down');
                        that.timer = null;
                    }, 2000);
                }
            }
        }]);

        return PROCESS;
    }();

    /*----------------------content---------------------------------------*/


    var PLUG = {
        confirm: function confirm() {
            var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                _ref$fn = _ref.fn,
                fn = _ref$fn === undefined ? null : _ref$fn,
                _ref$obj = _ref.obj,
                obj = _ref$obj === undefined ? { title: '提示', content: '提示内容。', btn: ['取消', '确认'] } : _ref$obj;

            return new CONFIRM(fn, obj);
        },
        tips: function tips(cfg, fn) {
            return new TIPS(cfg, fn);
        }

    };
    var FN_PLUG = {
        process: function process() {
            return new PROCESS(this);
        }
    };

    $.extend(PLUG);
    $.extend($.fn, FN_PLUG);
})(window, jQuery);